;
;
;

org 100h ; ax=bx=0 ch=0 si=0x100 sp=di=-2

; 54                push sp
; 3F                aas
; 5F                pop di
; 40                inc ax
; 90                nop
; 40                inc ax
; 853F              test [bx],di

C5div6 equ $-2
  db 0x54,0x3f  ; 5/6
  db 0x5f,0x40  ; 3.5
C4_5 equ $-2
  db 0x90,0x40  ; 4.5
C2PIdiv6 equ $-2
  db 0x85,0x3f  ; 2π/6 = 1.047197551

%define W(x) word[byte si-100h+x]
%define D(x) dword[byte si-100h+x]

S xchg ax,cx  ; cx=2
  mov fs,[si]
  mov al,13h  ; 320x200
  int 10h
  mov bp,0xa000-70-6
  mov es,bp

X mov ax,0xcccd
  mul di
  add dx,bp
;  push dx  ; +2 bytes: more precise
  pusha   ;[-10 -8 -6 -4]
          ;  dx cx ax dx
          ;   Y  T     Y
          ;  X        X

;  fild word[bx-4]
;  fild word[bx-5] ; y x
  fild word[bx-8]
  fild word[bx-9] ; y x
  fld st1         ; x y x
  fpatan          ; a=atan2(x,y) x  ; -π..π
  fld st0         ; a a x
  fcos            ; cos(a) a x
  fimul W(C295)
  fdivp st2,st0   ; a r=x/(-295*cos(a))  ; √(x²+y²)

; aad is slow to emulate
;  mov ax,7*256 + 32+24+24+24+19+24
;  and ah,ch
;  aad 3 ; al += 3*ah
  mov al,ch  ; +2 bytes: faster
  and al,7
  lea ax,[byte eax+2*eax+32+24+24+24+19+24]

  shl ch,6  ; 00000uvw -> cf=u sf=v pf=v^w
  jnc A

;Clover: C / (C - cos(4.5 sin(2a)));
C jnp G
  fadd st0        ; 2a r
  jns D
C295:
  fsin

;Flower with 9 petals / butterfly
G fmul D(C4_5)
  fcos
  fchs
  js I
  fabs
  jmp I

;Gear: C / (C + sin(cos(7a) + 2C)) ; 2C-2π ≈ π/4
B fmul dword[si]  ; Gear (7 points)
  jns F           ; Sun (22 points)
  fadd st0
  fcos
  fadd dword[si]  ; "fabs" is a no-op here

;Heart: C / (C + sin(|2a| + C))
D fabs            ; |2a| r
  fadd dword[si]
  fsin            ; s=sin(|2a|+C) r
I fadd dword[si]
  fdivr dword[si] ; C/(C+s) r
  jmp J

;Hexagon / star / sun
A jnp B
  fdiv D(C2PIdiv6)  ; a/Q r           ; Q = 2π/N
  jns F           ; Star: 5 points instead of 6
  fmul D(C5div6)
F fist word[bp+si]
  fisub word[bp+si] ; fract(a/Q)-0.5 r
  jns E
  fadd st0        ; Star: more pointy
E fmul D(C2PIdiv6)
  fcos              ; s=cos(Q*(fract(a/Q)-0.5)) r
J fmulp

P fistp word[bp+si]
  xor cl,16
  add cl,[bp+si]
  shr cl,6        ; set cf
  jnc Q
  add al,72

; shading
Q mov bx,-640
  mov [fs:di],al
Y cmp al,[fs:di+bx]
  jae Z
  sub al,48
Z sar bx,8
  jnp Y

  stosb
  popa
;  pop dx

  inc di
M jnz X

  mov dx,0x3da  ; vsync
V in al,dx
  test al,8
  jz V

  pusha
  mov ah,ch
  mov bl,cl     ; bh=0
  and cx,7
  jnz SKIPMIDI

  mov si,MIDI
  mov dl,0x30   ; MIDI data port

  mov cl,9
  xor byte[si+6],36^42  ; bass drum or closed hi-hat
  rep outsb

  shr bx,5
  xor byte[bx+si+5],32
  mov al,[bx+si+5]
  out dx,al
  outsb

  ror dword[si],4
  lodsb
  and al,0xf
  add al,32+24
  out dx,al
  shr ax,4
  and al,0x40
  out dx,al

SKIPMIDI:
  popa
  inc cx  ; t++

  in al,60h  ; ax=100
  cmp al,1
  jnz M

MIDI:
  ret  ; c3 = instrument change

;  db 0xc3
  db       81       ; ch4 instrument: saw wave
  db 0xb3, 123, 0   ;     notes off
  db 0x99, 36, 0x7f ; bass drum
  db 0x93, 0x7f     ;     play notes

  %define TR 32

  dd 0x8507587F    ; melody

  db TR+0,TR+1,TR+1,TR+1,TR+5,TR+5,TR+3,TR+3  ; base notes

